/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import lombok.Generated;
import net.runelite.launcher.Launcher;
import net.runelite.launcher.SplashScreen;
import net.runelite.launcher.beans.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum DownloadSimple {

    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadSimple.class);

    static void download(List<Artifact> artifacts) throws IOException {
        double START_PROGRESS = 0.15;
        long netSize = Long.MIN_VALUE;
        SplashScreen.stage(0.15, "Downloading", "");
        for (Artifact artifact : artifacts) {
            HttpResponse<InputStream> response;
            String artifactName = artifact.getName();
            String artifactNetPath = artifact.getPath();
            File artifactFile = new File(Launcher.REPO_DIR, artifactName);
            Path artifactFilePath = artifactFile.toPath();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(artifactNetPath)).header("User-Agent", Launcher.USER_AGENT).GET().build();
            try {
                response = Launcher.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            if (response.statusCode() != 200) {
                throw new IOException("Unable to download " + artifactNetPath + " (status code " + response.statusCode() + ")");
            }
            boolean upToDate = false;
            long diskSize = Long.MIN_VALUE;
            if (Files.exists(artifactFilePath, new LinkOption[0])) {
                try {
                    diskSize = Files.size(artifactFilePath);
                }
                catch (Exception ex) {
                    log.error("Error getting size of file \"" + String.valueOf(artifactFilePath) + "\"", ex);
                }
            }
            try {
                List<String> contentLengthHeaders = response.headers().allValues("Content-Length");
                if (contentLengthHeaders.isEmpty()) {
                    log.warn("Content-Length header not found for artifact path \"{}\"", (Object)artifactNetPath);
                } else {
                    String contentLength = contentLengthHeaders.get(0);
                    log.debug("Artifact path \"{}\" content length file size: \"{}\"", (Object)artifactNetPath, (Object)contentLength);
                    netSize = Long.parseLong(contentLength);
                    if (diskSize == netSize) {
                        upToDate = true;
                    }
                    log.debug("Artifact \"{}\" - disk size: {}, net size: {}, up-to-date: {}", artifactName, diskSize, netSize, upToDate);
                }
            }
            catch (Exception ex) {
                log.error("Error getting content length header for artifact path \"" + artifactNetPath + "\"", ex);
            }
            if (upToDate) {
                log.debug("Artifact \"{}\" - up to date", (Object)artifactName);
                continue;
            }
            log.debug("Downloading \"{}\"...", (Object)artifactName);
            long downloaded = 0L;
            InputStream in = response.body();
            try {
                FileChannel fileChannel = FileChannel.open(artifactFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                try {
                    int bytesRead;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
                    byte[] bytes = new byte[buffer.capacity()];
                    while ((bytesRead = in.read(bytes)) != -1) {
                        buffer.clear();
                        buffer.put(bytes, 0, bytesRead);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            int written = fileChannel.write(buffer);
                            SplashScreen.stage(0.15, 0.8, null, artifactName, downloaded += (long)written, netSize, true);
                        }
                    }
                }
                finally {
                    if (fileChannel == null) continue;
                    fileChannel.close();
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }
}

